/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater;

import com.sun.tools.tzupdater.CompatibilityKeeper;
import com.sun.tools.tzupdater.DataConfiguration;
import com.sun.tools.tzupdater.ExternalModule;
import com.sun.tools.tzupdater.Logger;
import com.sun.tools.tzupdater.Messages;
import com.sun.tools.tzupdater.TzRuntimeException;
import com.sun.tools.tzupdater.TzupdaterException;
import com.sun.tools.tzupdater.Verifier;
import com.sun.tools.tzupdater.utils.UtilsHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class TimezoneUpdater {
    private static final String ZIP_SUFFIX = ".zip";
    private static final String COMPAT_SUFFIX = ".compat";
    private static final String TEST_SUFFIX = ".test";
    private static final String SCRIPT_NAME = "pkg_resolve.sh";
    private static final String TZDB_RESOURCE_PATH = "/data/tzdb.dat";
    private static final int BUFSIZE = 8192;
    private final String vendor = System.getProperty("java.vendor");
    private final String jreVersion = System.getProperty("java.version");
    private final String javaHome = System.getProperty("java.home");
    private final String osName = System.getProperty("os.name");
    private static String currentID = "";
    private static boolean helpOnly;
    private static boolean showVersionOnly;
    private static boolean verificationOnly;
    private static boolean performUpdate;
    private static boolean forceUpdate;
    private static boolean keepCompatibility;
    private static boolean externalResourceBundle;
    private static boolean jsr310;
    private static boolean verbose;
    private static String url;
    private static File tmpDynamicDir;

    public TimezoneUpdater(String[] stringArray, PrintStream printStream) {
        int n = Integer.parseInt(this.jreVersion.substring(2, 3));
        if (n >= 8) {
            jsr310 = true;
        }
        for (String string : stringArray) {
            if (!string.equals("-v") && !string.equals("--verbose")) continue;
            verbose = true;
            break;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                helpOnly = true;
                return;
            }
            if (string.equals("-V") || string.equals("--version")) {
                if (stringArray.length > 1) {
                    helpOnly = true;
                    break;
                }
                showVersionOnly = true;
                break;
            }
            if (string.equals("-t") || string.equals("--test")) {
                verificationOnly = true;
                continue;
            }
            if (string.equals("-u") || string.equals("--update")) {
                performUpdate = true;
                continue;
            }
            if (string.equals("-f") || string.equals("--force")) {
                performUpdate = true;
                forceUpdate = true;
                continue;
            }
            if (string.equals("-bc") || string.equals("--backwardcompatible")) {
                keepCompatibility = true;
                continue;
            }
            if (string.equals("-v") || string.equals("--verbose")) continue;
            if (string.equals("-l") || string.equals("--location")) {
                if (i == stringArray.length - 1 || stringArray[i + 1].startsWith("-")) {
                    Logger.init(true, printStream);
                    throw new TzRuntimeException(Messages.printf("no.data.resource"));
                }
                url = stringArray[++i];
                externalResourceBundle = true;
                performUpdate = true;
                continue;
            }
            Logger.init(true, printStream);
            Logger.error(Messages.printf("unknown.flag", string));
            Logger.error(Messages.printf("usage", string));
            throw new TzRuntimeException();
        }
        if (showVersionOnly) {
            verbose = true;
        }
        Logger.init(verbose, printStream);
        if (externalResourceBundle && keepCompatibility) {
            throw new TzRuntimeException(Messages.printf("bc.not.supported"));
        }
        if (verificationOnly) {
            forceUpdate = false;
        }
        if (performUpdate) {
            if (showVersionOnly || verificationOnly) {
                helpOnly = true;
            }
        } else if (keepCompatibility && !verificationOnly || !showVersionOnly && !verificationOnly) {
            helpOnly = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (helpOnly) {
            System.out.println(Messages.printf("usage"));
            return;
        }
        if (!showVersionOnly) {
            Logger.println(Messages.printf("java.home", this.javaHome));
            Logger.println(Messages.printf("java.vendor", this.vendor));
            Logger.println(Messages.printf("java.version", this.jreVersion));
        } else {
            Logger.println("tzupdater version 2.0.0-b03");
        }
        try {
            Object object;
            if (externalResourceBundle) {
                tmpDynamicDir = TimezoneUpdater.getTempDir(System.getProperty("java.io.tmpdir"));
                object = ExternalModule.downloadFile(url, tmpDynamicDir + File.separator + "tzdata.tar.gz");
                ExternalModule.extractFiles((String)object);
            }
            object = DataConfiguration.getDataConfiguration(this.vendor, this.jreVersion, tmpDynamicDir);
            String string = ((DataConfiguration)object).getTzID();
            String string2 = UtilsHelper.toTzdbFileName(this.javaHome);
            if (externalResourceBundle) {
                ExternalModule.createVersionFile(tmpDynamicDir.getPath(), string);
                if (jsr310) {
                    string2 = UtilsHelper.toTzdbFileName(this.javaHome);
                    if (string2 == null) {
                        throw new TzRuntimeException(Messages.printf("no.tzdb.file"));
                    }
                    ExternalModule.compileToJSRBinary(tmpDynamicDir.getPath(), string2 + ".dynamic");
                } else {
                    ExternalModule.compileToZiBinary(string, tmpDynamicDir.getPath());
                }
            }
            String string3 = null;
            if (!jsr310) {
                string3 = UtilsHelper.toZiDirName(this.javaHome);
                if (string3 == null) {
                    throw new TzRuntimeException(Messages.printf("no.zi"));
                }
                currentID = UtilsHelper.getTzID(string3);
            } else {
                currentID = UtilsHelper.getTzIDFromTZDB(string2);
            }
            Logger.println(Messages.printf("jre.tzdata.version", currentID));
            if (object == null) {
                throw new TzRuntimeException(Messages.printf("no.tzdata", this.vendor, this.jreVersion));
            }
            Logger.println(Messages.printf("tool.tzdata.version", ((DataConfiguration)object).getTzID()));
            if (externalResourceBundle) {
                ExternalModule.verifyHash(url, tmpDynamicDir.getPath(), ((DataConfiguration)object).getTzID());
            }
            if (showVersionOnly) {
                return;
            }
            if (verificationOnly) {
                this.verify((DataConfiguration)object, null);
                return;
            }
            this.checkIfSameVersion(((DataConfiguration)object).getTzID());
            if (!jsr310) {
                this.update(string3, currentID, (DataConfiguration)object);
            } else {
                this.updateTzDB(tmpDynamicDir == null ? null : string2 + ".dynamic");
            }
            if (externalResourceBundle) {
                ExternalModule.compileTestFiles(tmpDynamicDir + File.separator + "tzdata.test.dynamic");
                this.verify((DataConfiguration)object, tmpDynamicDir + File.separator + "tzdata.test.dynamic");
            }
            Logger.println(Messages.printf("state.complete", ((DataConfiguration)object).getTzID()));
        }
        finally {
            TimezoneUpdater.remove(tmpDynamicDir);
        }
    }

    private void update(String string, String string2, DataConfiguration dataConfiguration) throws IOException {
        Object object;
        String string3 = dataConfiguration.getTzID();
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.canWrite()) {
            throw new TzRuntimeException(Messages.printf("not.writable", file2.getAbsolutePath()));
        }
        File file3 = TimezoneUpdater.getUniqueFile(string, string3);
        String string4 = dataConfiguration.getArchiveName();
        if (!verificationOnly) {
            try {
                this.extract(file3, string4 + ZIP_SUFFIX);
            }
            catch (IOException iOException) {
                TimezoneUpdater.remove(file3);
                throw iOException;
            }
        }
        List list = null;
        if (keepCompatibility && (object = CompatibilityKeeper.forID(string4 + COMPAT_SUFFIX)) != null) {
            Logger.print(Messages.printf("state.compat"));
            ((CompatibilityKeeper)object).keepCompatible(file3);
            list = ((CompatibilityKeeper)object).getExcludeList();
            Logger.println(Messages.printf("state.done"));
        }
        object = TimezoneUpdater.getUniqueFile(string, string2);
        Logger.println(Messages.printf("state.renaming", file.getPath(), ((File)object).getPath()));
        if (!file.renameTo((File)object)) {
            TimezoneUpdater.remove(file3);
            Logger.println(Messages.printf("state.failed"));
            throw new TzRuntimeException(Messages.printf("error.cannot.rename", file, object));
        }
        Logger.println(Messages.printf("state.renaming", file3.getPath(), file.getPath()));
        if (!file3.renameTo(file)) {
            Logger.println(Messages.printf("state.failed"));
            Logger.error(Messages.printf("error.cannot.rename", file3, file));
            Logger.print(Messages.printf("state.restoring"));
            if (((File)object).renameTo(file)) {
                TimezoneUpdater.remove(file3);
                throw new TzRuntimeException(Messages.printf("state.done"));
            }
            Logger.println();
            throw new TzRuntimeException(Messages.printf("error.cannot.restore", file));
        }
        if (externalResourceBundle) {
            return;
        }
        Logger.println(Messages.printf("state.validating", dataConfiguration.getTzID()));
        if (!Verifier.run(string4 + TEST_SUFFIX, list)) {
            Logger.println(Messages.printf("state.failed"));
            Logger.error(Messages.printf("state.validation.failed"));
            Logger.print(Messages.printf("state.restoring"));
            if (file.renameTo(file3)) {
                TimezoneUpdater.remove(file3);
                if (((File)object).renameTo(file)) {
                    throw new TzRuntimeException(Messages.printf("state.done"));
                }
                throw new TzRuntimeException(Messages.printf("error.cannot.restore", file));
            }
            throw new TzRuntimeException(Messages.printf("error.cannot.rename", file, file3));
        }
        this.correctPackageDB();
        Logger.println(Messages.printf("state.done"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTzDB(String string) {
        File file = null;
        try {
            File file2 = new File(this.javaHome, "lib");
            if (!file2.exists()) {
                file2 = new File(this.javaHome + File.separator + "jre" + File.separator + "lib");
            }
            file = TimezoneUpdater.getTempDir(file2.getAbsolutePath());
            File file3 = new File(file2, "tzdb.dat");
            File file4 = new File(file2, "tzdb.dat." + currentID);
            Logger.println(Messages.printf("state.renaming", file3.getPath(), file4.getPath()));
            if (!file3.renameTo(file4)) {
                Logger.println(Messages.printf("state.failed"));
                throw new TzRuntimeException(Messages.printf("error.cannot.rename", file3, file4));
            }
            File file5 = null;
            if (string != null) {
                file5 = new File(string);
            } else {
                this.extractFile(file, TZDB_RESOURCE_PATH);
                file5 = new File(file.getAbsoluteFile() + File.separator + "data" + File.separator + "tzdb.dat");
            }
            Logger.println(Messages.printf("state.renaming", file5.getPath(), file3.getPath()));
            if (!file5.renameTo(file3)) {
                Logger.println(Messages.printf("state.failed"));
                throw new TzRuntimeException(Messages.printf("error.cannot.rename", file5, file3));
            }
            TimezoneUpdater.remove(file);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                Logger.error(string2);
            }
        }
        finally {
            TimezoneUpdater.remove(file);
        }
    }

    private void checkIfSameVersion(String string) {
        if (!forceUpdate) {
            int n = currentID.compareTo(string);
            if (n == 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.same", string));
            }
            if (n > 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.later", currentID, string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(File file, String string) throws IOException {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        try {
            if (!externalResourceBundle) {
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    throw new TzupdaterException(string + " not found");
                }
                this.extract(file, inputStream);
            } else {
                zipFile = new ZipFile(new File(string));
                this.extractFromZipFile(file, zipFile);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(File file, InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ZipInputStream zipInputStream = null;
        ArrayList<ZipEntry> arrayList = null;
        ZipEntry zipEntry = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            Logger.print(Messages.printf("state.extracting"));
            if (!file.mkdirs()) {
                Logger.println(Messages.printf("state.failed"));
                throw new IOException(Messages.printf("error.cannot.mkdir", file));
            }
            arrayList = new ArrayList<ZipEntry>(64);
            object3 = new byte[8192];
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                object2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!((File)object2).mkdirs()) {
                        Logger.println(Messages.printf("state.failed"));
                        throw new IOException(Messages.printf("error.cannot.mkdir", object2));
                    }
                    arrayList.add(zipEntry);
                } else {
                    object = null;
                    try {
                        object = new FileOutputStream((File)object2);
                        this.copy(zipInputStream, (OutputStream)object, zipEntry.getSize(), (byte[])object3);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Logger.println(Messages.printf("state.failed"));
                        throw fileNotFoundException;
                    }
                    finally {
                        if (object != null) {
                            ((OutputStream)object).close();
                        }
                    }
                    try {
                        ((File)object2).setWritable(true, true);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    ((File)object2).setLastModified(zipEntry.getTime());
                    ((File)object2).setReadOnly();
                    try {
                        ((File)object2).setExecutable(false);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (ZipEntry)object3.next();
            object = new File(file, ((ZipEntry)object2).getName());
            try {
                ((File)object).setWritable(true, true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            ((File)object).setLastModified(((ZipEntry)object2).getTime());
        }
        zipInputStream.close();
        Logger.println(Messages.printf("state.done"));
    }

    private void extractFromZipFile(File file, ZipFile zipFile) throws IOException {
        InputStream inputStream = null;
        Logger.print(Messages.printf("state.extracting"));
        if (!file.mkdirs()) {
            Logger.println(Messages.printf("state.failed"));
            throw new IOException(Messages.printf("error.cannot.mkdir", file));
        }
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>(64);
        byte[] byArray = new byte[8192];
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            File file2;
            ZipEntry zipEntry;
            block18: {
                FileOutputStream object;
                zipEntry = enumeration.nextElement();
                file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!file2.mkdirs()) {
                        Logger.println(Messages.printf("state.failed"));
                        throw new IOException(Messages.printf("error.cannot.mkdir", file2));
                    }
                    arrayList.add(zipEntry);
                    continue;
                }
                OutputStream outputStream = null;
                try {
                    object = new FileOutputStream(file2);
                    inputStream = zipFile.getInputStream(zipEntry);
                    this.copy(inputStream, object, zipEntry.getSize(), byArray);
                    if (object == null) break block18;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        Logger.println(Messages.printf("state.failed"));
                        throw fileNotFoundException;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable;
                    }
                }
                ((OutputStream)object).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            try {
                file2.setWritable(true, true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            file2.setLastModified(zipEntry.getTime());
            file2.setReadOnly();
            try {
                file2.setExecutable(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        }
        for (ZipEntry zipEntry : arrayList) {
            File noSuchMethodError = new File(file, zipEntry.getName());
            try {
                noSuchMethodError.setWritable(true, true);
            }
            catch (NoSuchMethodError noSuchMethodError2) {
                // empty catch block
            }
            noSuchMethodError.setLastModified(zipEntry.getTime());
        }
        Logger.println(Messages.printf("state.done"));
    }

    private void extractFile(File file, String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TzupdaterException(string + " not found in bundle");
        }
        Logger.print(Messages.printf("state.extracting"));
        byte[] byArray = new byte[8192];
        File file2 = new File(file, string);
        Logger.println("Creating: " + file + File.separator + ": " + string);
        OutputStream outputStream = null;
        try {
            if (string.lastIndexOf(47) > 0) {
                File file3 = new File(file2.getParent());
                if (file3.mkdirs()) {
                    Logger.println("Need to make dir " + file3.getAbsolutePath());
                } else {
                    Logger.error("Failed to make dir " + file3.getAbsolutePath());
                    throw new IOException("cannot make directory " + file3.getAbsolutePath());
                }
            }
            outputStream = new FileOutputStream(file2);
            this.copy(inputStream, outputStream, byArray);
            Logger.println(Messages.printf("state.done"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.error(Messages.printf("state.failed"));
            throw fileNotFoundException;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void verify(DataConfiguration dataConfiguration, String string) throws IOException {
        Object object;
        String string2 = dataConfiguration.getArchiveName();
        List list = null;
        if ((keepCompatibility || jsr310) && (object = CompatibilityKeeper.forID(string2 + COMPAT_SUFFIX)) != null) {
            ((CompatibilityKeeper)object).keepCompatible(null);
            list = ((CompatibilityKeeper)object).getExcludeList();
        }
        Logger.println(Messages.printf("state.validating", dataConfiguration.getTzID()));
        Object object2 = object = string == null ? string2 + TEST_SUFFIX : string;
        if (!Verifier.run((String)object, list)) {
            Logger.println();
            throw new TzRuntimeException(Messages.printf("state.validation.failed"));
        }
        Logger.println(Messages.printf("state.validation.complete"));
    }

    private void copy(InputStream inputStream, OutputStream outputStream, long l, byte[] byArray) throws IOException {
        int n;
        while (l > 0L && (n = inputStream.read(byArray, 0, Math.min((int)l, byArray.length))) > 0) {
            outputStream.write(byArray, 0, n);
            l -= (long)n;
        }
    }

    private static void remove(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                TimezoneUpdater.remove(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    private void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, Math.min(inputStream.available(), byArray.length))) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static File getUniqueFile(String string, String string2) {
        File file = new File(string + "." + string2);
        if (file.exists()) {
            int n = 1;
            while ((file = new File(string + "." + string2 + "_" + n++)).exists()) {
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void correctPackageDB() throws IOException {
        BufferedReader bufferedReader;
        File file;
        block16: {
            if (!this.osName.toLowerCase().startsWith("sunos")) {
                return;
            }
            file = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            bufferedReader = null;
            try {
                String string;
                File file2 = new File(this.javaHome, "lib");
                if (!file2.exists()) {
                    file2 = new File(this.javaHome + File.separator + "jre" + File.separator + "lib");
                }
                file = TimezoneUpdater.getTempDir(file2.getAbsolutePath());
                this.extractFile(file, "/pkg_resolve.sh");
                File file3 = new File(this.javaHome, "bin");
                if (!file3.exists()) {
                    file3 = new File(this.javaHome + File.separator + "jre" + File.separator + "bin");
                }
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("/bin/ksh " + file.getAbsolutePath() + "/" + SCRIPT_NAME + " " + file3 + File.separator + "java");
                inputStream = process.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
                try {
                    if (process.waitFor() != 0) {
                        System.err.println("exit value = " + process.exitValue());
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                if (inputStreamReader == null) break block16;
            }
            catch (Exception exception) {
                block17: {
                    try {
                        String string = exception.getMessage();
                        if (string != null) {
                            Logger.error(string);
                        }
                        if (inputStreamReader == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        TimezoneUpdater.remove(file);
                        throw throwable;
                    }
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                TimezoneUpdater.remove(file);
            }
            inputStreamReader.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        TimezoneUpdater.remove(file);
    }

    private static File getTempDir(String string) {
        File file = TimezoneUpdater.getUniqueFile(string + File.separator + "tz", "tmp");
        boolean bl = file.mkdir();
        if (!bl) {
            throw new TzRuntimeException(Messages.printf("nocreate.tempdir", file.getAbsolutePath()));
        }
        return file;
    }

    public static void main(String[] stringArray) {
        try {
            TimezoneUpdater timezoneUpdater = new TimezoneUpdater(stringArray, null);
            timezoneUpdater.run();
            return;
        }
        catch (TzupdaterException tzupdaterException) {
            throw tzupdaterException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Throwable throwable = exception.getCause();
            if (string != null && (throwable != null && !(throwable instanceof TzRuntimeException) || exception instanceof TzRuntimeException)) {
                Logger.error(string);
            } else if (!(exception instanceof TzRuntimeException)) {
                Logger.error(exception.toString());
            }
            if (verbose) {
                throw new TzRuntimeException(exception);
            }
            System.exit(1);
            return;
        }
    }

    static {
        url = null;
        tmpDynamicDir = null;
    }
}

