/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class TestDataGenerator {
    private static int startYear = new GregorianCalendar().get(1);
    private static int testDuration = 5;
    private static boolean ProduceComments;
    private static OutputStream os;
    private static final int INTERVAL = 86400000;

    public TestDataGenerator(String string) throws IOException {
        os = new FileOutputStream(new File(string));
        ProduceComments = true;
    }

    private static void zdump(String string) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if (!timeZone.getID().equals(string)) {
            throw new RuntimeException("Invalid TimeZone ID: " + string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.clear();
        gregorianCalendar.set(startYear, 0, 1);
        long l = gregorianCalendar.getTimeInMillis();
        int n = gregorianCalendar.get(15);
        int n2 = gregorianCalendar.get(16);
        TestDataGenerator.printTransition(gregorianCalendar);
        gregorianCalendar.clear();
        gregorianCalendar.set(startYear + testDuration, 0, 1);
        long l2 = gregorianCalendar.getTimeInMillis();
        for (long i = l; i < l2; i += 86400000L) {
            gregorianCalendar.setTimeInMillis(i);
            int n3 = gregorianCalendar.get(15);
            int n4 = gregorianCalendar.get(16);
            if (n3 == n && n4 == n2) continue;
            long l3 = i;
            long l4 = i - 86400000L;
            while (l3 - l4 > 1L) {
                long l5 = l4 + (l3 - l4) / 2L;
                gregorianCalendar.setTimeInMillis(l5);
                int n5 = gregorianCalendar.get(15);
                int n6 = gregorianCalendar.get(16);
                if (n5 == n && n6 == n2) {
                    l4 = l5;
                    continue;
                }
                l3 = l5;
            }
            gregorianCalendar.setTimeInMillis(l4);
            TestDataGenerator.printTransition(gregorianCalendar);
            gregorianCalendar.setTimeInMillis(l3);
            TestDataGenerator.printTransition(gregorianCalendar);
            n = gregorianCalendar.get(15);
            n2 = gregorianCalendar.get(16);
            i = l4;
        }
    }

    private static void printTransition(GregorianCalendar gregorianCalendar) throws IOException {
        Object object;
        Formatter formatter = new Formatter();
        Offset offset = new Offset(gregorianCalendar.get(15));
        formatter.format("%s\t%d\t%s\t", gregorianCalendar.getTimeZone().getID(), gregorianCalendar.getTimeInMillis(), offset.toString(false));
        Offset offset2 = new Offset(gregorianCalendar.get(16));
        if (offset2.isZero()) {
            formatter.format("0", new Object[0]);
        } else {
            formatter.format(offset2.toString(false), new Object[0]);
        }
        if (ProduceComments) {
            object = new Offset(gregorianCalendar.get(15) + gregorianCalendar.get(16));
            formatter.format("\t# %tY-%<tm-%<tdT%<tH:%<tM:%<tS.%<tL", gregorianCalendar);
            if (((Offset)object).isZero()) {
                formatter.format("Z", new Object[0]);
            } else {
                formatter.format(((Offset)object).toString(true), new Object[0]);
            }
        }
        if (os == null) {
            System.out.println(formatter);
        } else {
            object = formatter.toString() + "\n";
            os.write(((String)object).getBytes("UTF-8"));
        }
    }

    public static void dumpIDs(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            if (string.contains("Riyadh")) continue;
            TestDataGenerator.zdump(string);
        }
        if (os != null) {
            os.close();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            if ("-h".equals(stringArray2)) {
                System.out.println("Usage: java TestDataGenerator [-c] [-y year] [-d duration] [tzid ...]");
                System.out.println("   -c            produce human readable data as comments");
                System.out.println("   -y year       start year");
                System.out.println("   -d duration   duration in years");
                System.out.println("   tzid...       time zone ids (default: produce data for all tzids)");
                return;
            }
            if ("-c".equals(stringArray2)) {
                ProduceComments = true;
                continue;
            }
            if ("-y".equals(stringArray2)) {
                startYear = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (!"-d".equals(stringArray2)) break;
            testDuration = Integer.parseInt(stringArray[++n]);
        }
        if (n == stringArray.length) {
            stringArray2 = TimeZone.getAvailableIDs();
        } else {
            int n2 = stringArray.length - n;
            stringArray2 = new String[n2];
            System.arraycopy(stringArray, n, stringArray2, 0, n2);
        }
        TestDataGenerator.dumpIDs(stringArray2);
    }

    static {
        os = null;
    }

    private static class Offset {
        int offset;
        int sign;
        int h;
        int m;
        int s;

        Offset(int n) {
            this.offset = n;
            this.sign = n >= 0 ? 1 : -1;
            n *= this.sign;
            this.s = (n /= 1000) % 60;
            this.h = (n /= 60) / 60;
            this.m = n % 60;
        }

        boolean isZero() {
            return this.offset == 0;
        }

        String getSign(boolean bl) {
            if (this.sign < 0) {
                return "-";
            }
            return bl ? "+" : "";
        }

        int getHours() {
            return this.h;
        }

        int getMinutes() {
            return this.m;
        }

        String toString(boolean bl) {
            if (this.s == 0) {
                return String.format("%s%d:%02d", this.getSign(bl), this.h, this.m);
            }
            return String.format("%s%d:%02d:%02d", this.getSign(bl), this.h, this.m, this.s);
        }
    }
}

