/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import tools.tzdb.ChronoField;
import tools.tzdb.DateTimeException;
import tools.tzdb.Utils;

final class LocalDate {
    public static final LocalDate MIN = new LocalDate(-999999999, 1, 1);
    public static final LocalDate MAX = new LocalDate(999999999, 12, 31);
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    private final int year;
    private final short month;
    private final short day;

    public static LocalDate of(int n, int n2, int n3) {
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.MONTH_OF_YEAR.checkValidValue(n2);
        ChronoField.DAY_OF_MONTH.checkValidValue(n3);
        if (n3 > 28 && n3 > Utils.lengthOfMonth(n2, Utils.isLeapYear(n))) {
            if (n3 == 29) {
                throw new DateTimeException("Invalid date 'February 29' as '" + n + "' is not a leap year");
            }
            throw new DateTimeException("Invalid date '" + n2 + " " + n3 + "'");
        }
        return new LocalDate(n, n2, n3);
    }

    private LocalDate(int n, int n2, int n3) {
        this.year = n;
        this.month = (short)n2;
        this.day = (short)n3;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfWeek() {
        return (int)Utils.floorMod(this.toEpochDay() + 3L, 7L) + 1;
    }

    public LocalDate plusDays(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = Utils.addExact(this.toEpochDay(), l);
        return LocalDate.ofEpochDay(l2);
    }

    public LocalDate minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public static LocalDate ofEpochDay(long l) {
        long l2;
        long l3;
        long l4 = l + 719528L;
        long l5 = 0L;
        if ((l4 -= 60L) < 0L) {
            l3 = (l4 + 1L) / 146097L - 1L;
            l5 = l3 * 400L;
            l4 += -l3 * 146097L;
        }
        if ((l2 = l4 - (365L * (l3 = (400L * l4 + 591L) / 146097L) + l3 / 4L - l3 / 100L + l3 / 400L)) < 0L) {
            l2 = l4 - (365L * --l3 + l3 / 4L - l3 / 100L + l3 / 400L);
        }
        l3 += l5;
        int n = (int)l2;
        int n2 = (n * 5 + 2) / 153;
        int n3 = (n2 + 2) % 12 + 1;
        int n4 = n - (n2 * 306 + 5) / 10 + 1;
        int n5 = ChronoField.YEAR.checkValidValue((int)(l3 += (long)(n2 / 10)));
        return new LocalDate(n5, n3, n4);
    }

    public long toEpochDay() {
        long l = this.year;
        long l2 = this.month;
        long l3 = 0L;
        l3 += 365L * l;
        l3 = l >= 0L ? (l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l3 -= l / -4L - l / -100L + l / -400L);
        l3 += (367L * l2 - 362L) / 12L;
        l3 += (long)(this.day - 1);
        if (l2 > 2L) {
            --l3;
            if (!Utils.isLeapYear(this.year)) {
                --l3;
            }
        }
        return l3 - 719528L;
    }

    public int compareTo(LocalDate localDate) {
        int n = this.year - localDate.year;
        if (n == 0 && (n = this.month - localDate.month) == 0) {
            n = this.day - localDate.day;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDate) {
            return this.compareTo((LocalDate)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.year;
        short s = this.month;
        short s2 = this.day;
        return n & 0xFFFFF800 ^ (n << 11) + (s << 6) + s2;
    }
}

